/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.rcs.sas;

import com.ibm.hwmca.fw.rcs.sas.SasUtil;
import com.ibm.hwmca.fw.util.Trace;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class LicenseAcceptance
implements Serializable {
    private static final String TRACE_MASKT = "XSASLACT";
    private static final String TRACE_MASKF = "XSASLACF";
    private static final String TRACE_MASKD = "XSASLACD";
    private static final String LICENSE_ACCEPTANCE = "license-acceptance";
    private static final String LICENSING_USERID = "licensing-userid";
    private static final String LICENSING_TIMESTAMP = "licensing_TIMESTAMP";
    public String licensingUserid;
    public Date licensingTimestamp;

    public LicenseAcceptance() {
        this(null, null);
        Trace.trace(TRACE_MASKT, "<> LicenseAcceptance.LicenseAcceptance()");
    }

    public LicenseAcceptance(String licensingUserid, Date licensingTimestamp) {
        this.licensingUserid = licensingUserid;
        this.licensingTimestamp = licensingTimestamp;
        Trace.trace(TRACE_MASKT, "<> LicenseAcceptance.LicenseAcceptance(licensingUserid=" + licensingUserid + ", " + "licensingTimestamp=" + licensingTimestamp + ")");
    }

    public String toXml() {
        Trace.trace(TRACE_MASKT, "-> LicenseAcceptance.toXml()");
        StringBuffer buffer = new StringBuffer();
        buffer.append("<");
        buffer.append(LICENSE_ACCEPTANCE);
        if (this.licensingUserid != null && this.licensingUserid.length() > 0) {
            buffer.append(" ");
            buffer.append("licensing-userid=\"" + SasUtil.convert4Xml(this.licensingUserid) + "\"");
        }
        if (this.licensingTimestamp != null) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            dateFormat.setTimeZone(TimeZone.getTimeZone("GMT+0"));
            buffer.append(" ");
            buffer.append("licensing_TIMESTAMP=\"" + SasUtil.convert4Xml(dateFormat.format(this.licensingTimestamp)) + "\"");
        }
        buffer.append("/>");
        Trace.trace(TRACE_MASKT, "<- LicenseAcceptance.toXml()");
        return buffer.toString();
    }

    public Object clone() {
        Trace.trace(TRACE_MASKT, "-> LicenseAcceptance.clone()");
        Object object = null;
        try {
            object = super.clone();
        }
        catch (CloneNotSupportedException exc) {
            Trace.trace(TRACE_MASKF, exc);
        }
        Trace.trace(TRACE_MASKT, "<- LicenseAcceptance.clone()");
        return object;
    }

    public boolean equals(Object object) {
        Trace.trace(TRACE_MASKT, "-> LicenseAcceptance.equals(" + object + ")");
        boolean result = false;
        if (object != null && object instanceof LicenseAcceptance) {
            LicenseAcceptance licenseAcceptance = (LicenseAcceptance)object;
            if (this.licensingUserid.equals(licenseAcceptance.licensingUserid) && this.licensingTimestamp.equals(licenseAcceptance.licensingTimestamp)) {
                result = true;
            }
        }
        Trace.trace(TRACE_MASKT, "<- LicenseAcceptance.equals()");
        return result;
    }
}

